/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.features.BuildingListFeatureConfig;
import org.betterx.betterend.world.features.NBTFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.jetbrains.annotations.Nullable;

public class BuildingListFeature
extends NBTFeature<BuildingListFeatureConfig> {
    private StructureInfo selected;

    public BuildingListFeature() {
        super(BuildingListFeatureConfig.CODEC);
    }

    @Override
    protected void addStructureData(class_3492 data) {
        data.method_16184((class_3491)new ChestProcessor());
    }

    @Override
    protected class_3499 getStructure(BuildingListFeatureConfig cfg, class_5281 world, class_2338 pos, class_5819 random) {
        this.selected = cfg.getRandom(random);
        return this.selected.getStructure();
    }

    @Override
    protected boolean canSpawn(class_5281 world, class_2338 pos, class_5819 random) {
        int cz;
        int cx = pos.method_10263() >> 4;
        return (cx + (cz = pos.method_10260() >> 4) & 1) == 0 && pos.method_10264() > 58 && world.method_8320(pos).method_26215() && world.method_8320(pos.method_10074()).method_26164(CommonBlockTags.TERRAIN);
    }

    @Override
    protected class_2470 getRotation(class_5281 world, class_2338 pos, class_5819 random) {
        return class_2470.method_16548((class_5819)random);
    }

    @Override
    protected class_2415 getMirror(class_5281 world, class_2338 pos, class_5819 random) {
        return class_2415.values()[random.method_43048(3)];
    }

    @Override
    protected int getYOffset(class_3499 structure, class_5281 world, class_2338 pos, class_5819 random) {
        return this.selected.offsetY;
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(class_5281 world, class_2338 pos, class_5819 random) {
        return this.selected.terrainMerge;
    }

    class ChestProcessor
    extends class_3491 {
        ChestProcessor() {
        }

        @Nullable
        public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 blockPos, class_2338 blockPos2, class_3499.class_3501 structureBlockInfo, class_3499.class_3501 structureBlockInfo2, class_3492 structurePlaceSettings) {
            class_2680 blockState = structureBlockInfo2.field_15596;
            if (blockState.method_26204() instanceof class_2281) {
                class_5819 random = structurePlaceSettings.method_15115(structureBlockInfo2.field_15597);
                class_2338 chestPos = structureBlockInfo2.field_15597;
                class_2281 chestBlock = (class_2281)blockState.method_26204();
                class_2586 entity = chestBlock.method_10123(chestPos, blockState);
                levelReader.method_22350(chestPos).method_12007(entity);
                class_2621 chestEntity = (class_2621)entity;
                class_6880 biome = levelReader.method_16359(chestPos.method_10263() >> 2, chestPos.method_10264() >> 2, chestPos.method_10260() >> 2);
                chestEntity.method_11285(LootTableUtil.getTable((class_6880<class_1959>)biome), random.method_43055());
                chestEntity.method_5431();
            }
            return structureBlockInfo2;
        }

        protected class_3828<?> method_16772() {
            return class_3828.field_16987;
        }
    }

    public static final class StructureInfo {
        public static final Codec<StructureInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("path").forGetter(o -> o.structurePath), (App)Codec.INT.fieldOf("offset_y").forGetter(o -> o.offsetY), (App)NBTFeature.TerrainMerge.CODEC.fieldOf("terrain_merger").forGetter(o -> o.terrainMerge)).apply((Applicative)instance, StructureInfo::new));
        public final NBTFeature.TerrainMerge terrainMerge;
        public final String structurePath;
        public final int offsetY;
        private class_3499 structure;

        public StructureInfo(String structurePath, int offsetY, NBTFeature.TerrainMerge terrainMerge) {
            this.terrainMerge = terrainMerge;
            this.structurePath = structurePath;
            this.offsetY = offsetY;
        }

        public class_3499 getStructure() {
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure((String)this.structurePath);
            }
            return this.structure;
        }
    }
}

